#ifndef __PERIPH_H__
#define __PERIPH_H__

#define CAPTURE_CH0    0   //外部CCP1CH0 引脚输入信号 PA4
#define CAPTURE_CH1    1   //外部CCP1CH1 引脚输入信号 PA5
#define CAPTURE_CH2    2   //外部CCP1CH2 引脚输入信号 PB7
#define CAPTURE_CH3    3   //外部CCP1CH3 引脚输入信号 PB6
#define CAPTURE_CH4    4   //OP1OUT信号
#define CAPTURE_CH5    5   //内部32K 输入信号
#define CAPTURE_CH6    6   //外部32K 引脚输入信号
#define CAPTURE_CH7    7   //CMP1OUT输入信号
#define CAPTURE_CH8    8   //CCP1CH4 PB0
#define CAPTURE_CH9    9   //CCP1CH4 PB1
#define CAPTURE_CH10    10  //CCP1CH4 PB2
#define CAPTURE_CH11    11  //CCP1CH4 PB3
#define CAPTURE_CH12    12  //CCP1CH4 PB4
#define CAPTURE_CH13   13  //CCP1CH4 PB5
#define CAPTURE_CH14    14  //CCP1CH4 PC2
#define CAPTURE_CH15    15  //CCP1CH4 PC3

#define CAPTURE_MODE0 8    //捕捉模式，在每个下降沿发生，捕捉值存入CCPR1 寄存器，并产生中断标志 CCPIF
#define CAPTURE_MODE1 9    //捕捉模式，在每个上升沿发生，捕捉值存入CCPR1 寄存器，并产生中断标志 CCPIF
#define CAPTURE_MODE2 10   //捕捉模式，在每4 个上升沿发生一次，捕捉值存入 CCPR1 寄存器，并产生中断标志CCPIF
#define CAPTURE_MODE3 11   //捕捉模式，在每16 个上升沿发生一次，捕捉值存入 CCPR1 寄存器，并产生中断标志CCPIF
#define CAPTURE_MODE4 12   //捕捉模式，下降沿，复位 TIMER1，捕捉值存入CCPR1 寄存器，并产生中断标志 CCPIF
#define CAPTURE_MODE5 13   //捕捉模式，上升沿，复位 TIMER1，捕捉值存入CCPR1 寄存器，并产生中断标志 CCPIF
#define CAPTURE_MODE6 14   //捕捉模式，下降沿，捕捉值存入CCPR1 寄存器，不产生中断标志CCPIF
#define CAPTURE_MODE7 15   //捕捉模式，上升沿，捕捉值存入CCPR1 寄存器，不产生中断标志CCPIF

typedef signed   char   int8_t;     //!< Signed 8 bit integer
typedef unsigned char   uint8_t;    //!< Unsigned 8 bit integer

typedef signed   short  int16_t;    //!< Signed 16 bit integer
typedef unsigned short  uint16_t;   //!< Unsigned 16 bit integer

typedef signed   long   int32_t;    //!< Signed 32 bit integer
typedef unsigned long   uint32_t;   //!< Unsigned 32 bit integer

typedef unsigned char   bool;     //!< Boolean data type

void GPIO_Init(void);
void ADC_Config(void);
void Config_AD_GPIO(unsigned char TEMP_c);
unsigned short ADC_SampleFilter(void);
void Timer1_Timer(void);
void Timer2_Timer(void);
void Timer3_Timer(void);
void CCP_init(void);
void Timer1_Caputure_Init(uint8_t channel,uint8_t mode);
void Cmp_Cfg(unsigned char Pch,unsigned char Nch,unsigned char Mode);
#endif
